IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV') AND type in (N'P', N'PC'))
begin
	DROP PROCEDURE P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV
end
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20221101
'Job.................:  
'Nome................:  P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2022-11-01
'Alterado por........: Marcos barros
'Criado por..........: 
'=======================================================================================

-- EXEC  P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV  1
 */

CREATE PROCEDURE [dbo].[P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV](@FLAG_LIMPAR INT=0)        
WITH ENCRYPTION AS 
SET NOCOUNT ON;
BEGIN TRY
   BEGIN                
       IF OBJECT_ID('Tempdb.dbo.##CTB_EXP_MOV') IS NOT NULL
           BEGIN
               IF @FLAG_LIMPAR = 1
                   BEGIN
                       DROP TABLE ##CTB_EXP_MOV
                   END    
               ELSE
                   BEGIN
                       RETURN
                   END
           END
       print 'P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV - CREATE 1 ' + CONVERT(VARCHAR, GETDATE(), 108);
       CREATE TABLE ##CTB_EXP_MOV (CD_LANC                   INT IDENTITY(1,1),
                                   CD_EMP               INT,
                                   CD_FILIAL_EXPORT       INT,
                                   CD_FILIAL               INT,        
                                   CD_MOVIMENTO           INT,                        
                                   MOVIMENTO               VARCHAR(150),                                
                                   OPERACAO               VARCHAR(150),                                
                                   OPERACAO_DEBITO       VARCHAR(150),                                
                                   CD_CNT_RED_CREDITO       INT,
                                   CD_CNT_CREDITO           VARCHAR(100),
                                   CD_CNT_RED_DEBITO       INT,
                                   CD_CNT_DEBITO           VARCHAR(100),
                                   DT_MOV               DATETIME,
                                   HIST                   VARCHAR(300),
                                   VLR_LANC               MONEY,
                                   TP_TRANSA               VARCHAR(3),
                                   RATEIO_CENTRO_CUSTO       INT,
                                   DS_CENTRO_CUSTO       VARCHAR(150),
                                   CNT_CENTRO_CUSTO       VARCHAR(20) collate SQL_Latin1_General_CP1_CI_AS,
                                   VLR_CENTRO_CUSTO       MONEY,
                                   ORIG_CONTA           VARCHAR(150),
                                   COD_CONTA               VARCHAR(150),
                                   NM_PROCEDURE           VARCHAR(150),
                                   TIPO_LANCTO           VARCHAR(4),
                                   CD_EVENTO               INT,
                                   NR_DP               BIGINT,
                                   ANO                   INT,
                                   NR_DOC               VARCHAR(200),
                                   CD_BC_LANC           INT,
                                   CD_CENTRO_CTB_REDU       INT,
                                   COD_INTERNO INT,
                                   LOTE INT )    
   END
END TRY
BEGIN CATCH
   INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
       SELECT
           ERROR_NUMBER() AS numero,
           ERROR_SEVERITY() AS severidade,
           ERROR_STATE() AS estado,
           'P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV' AS rotina,
           ERROR_LINE() AS linha,
           ERROR_MESSAGE() AS mensagem,
           GETDATE() AS dtErro;    
END CATCH
PRINT 'P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV FINALIZADA!';
--SELECT * FROM ##CTB_EXP_MOV

GO